/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.core.notification.user.delayed.synthese;

import org.owasp.encoder.Encode;
import org.silverpeas.core.notification.user.AttachmentLink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Yohann Chastagnier
 */
public class SyntheseResource {

  private String name;
  private String description;
  private String location;
  private String url;
  private String linkLabel;
  private List<AttachmentLink> attachmentLinks = null;
  private final List<SyntheseResourceNotification> notifications = new ArrayList<>();

  public String getName() {
    return name;
  }

  public void setName(final String name) {
    this.name = name == null ? null : Encode.forHtml(name);
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(final String description) {
    this.description = description == null ? null : Encode.forHtml(description);
  }

  public String getLocation() {
    return location;
  }

  public void setLocation(final String location) {
    this.location = location == null ? null : Encode.forHtml(location);
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(final String url) {
    this.url = url;
  }

  public String getLinkLabel() {
    return linkLabel;
  }

  public void setLinkLabel(final String linkLabel) {
    this.linkLabel = linkLabel;
  }

  public void setAttachmentLinks(final List<AttachmentLink> attachmentLinks) {
    this.attachmentLinks = attachmentLinks;
  }

  public List<AttachmentLink> getAttachmentLinks() {
    return this.attachmentLinks == null ? Collections.emptyList():this.attachmentLinks;
  }

  public List<SyntheseResourceNotification> getNotifications() {
    return notifications;
  }

  public void addNotification(final SyntheseResourceNotification notification) {
    notifications.add(notification);
  }

  public boolean isSeveralNotifications() {
    return notifications.size() > 1;
  }
}
